/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.user.api.SimpleUserApi;
import net.guerlab.smart.user.api.autoconfig.SimpleUserApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignSimpleUserApi;
import net.guerlab.smart.user.core.domain.SimpleUserDTO;
import net.guerlab.smart.user.core.searchparams.UserSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SimpleUserApiLocalServiceAutoConfigure.class})
public class SimpleUserApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={SimpleUserApi.class})
    public SimpleUserApi simpleUserApiFeignWrapper(FeignSimpleUserApi api) {
        return new SimpleUserApiFeignWrapper(api);
    }

    private static class SimpleUserApiFeignWrapper
    implements SimpleUserApi {
        private final FeignSimpleUserApi api;

        @Override
        public SimpleUserDTO findOne(Long userId) {
            return Optional.ofNullable((SimpleUserDTO)this.api.findOne(userId).getData()).orElseThrow(UserInvalidException::new);
        }

        @Override
        public ListObject<SimpleUserDTO> findList(UserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<SimpleUserDTO> findAll(UserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public SimpleUserApiFeignWrapper(FeignSimpleUserApi api) {
            this.api = api;
        }
    }
}

