/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.SimpleDepartmentApi;
import net.guerlab.smart.user.core.domain.SimpleDepartmentDTO;
import net.guerlab.smart.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.user.service.entity.Department;
import net.guerlab.smart.user.service.service.DepartmentService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class SimpleDepartmentApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DepartmentService.class})
    public SimpleDepartmentApi simpleDepartmentApiLocalServiceWrapper(DepartmentService service) {
        return new SimpleDepartmentApiLocalServiceWrapper(service);
    }

    private static class SimpleDepartmentApiLocalServiceWrapper
    implements SimpleDepartmentApi {
        private final DepartmentService service;

        @Override
        public SimpleDepartmentDTO findOne(Long departmentId) {
            return (SimpleDepartmentDTO)BeanConvertUtils.toObject((Object)((Department)this.service.selectByIdOptional((Object)departmentId).orElseThrow(DepartmentInvalidException::new)), SimpleDepartmentDTO.class);
        }

        @Override
        public ListObject<SimpleDepartmentDTO> findList(DepartmentSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams), SimpleDepartmentDTO.class);
        }

        @Override
        public List<SimpleDepartmentDTO> findAll(DepartmentSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams), SimpleDepartmentDTO.class);
        }

        public SimpleDepartmentApiLocalServiceWrapper(DepartmentService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.user.service.service.DepartmentService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

