/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.user.api.SimpleDepartmentApi;
import net.guerlab.smart.user.api.autoconfig.SimpleDepartmentApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignSimpleDepartmentApi;
import net.guerlab.smart.user.core.domain.SimpleDepartmentDTO;
import net.guerlab.smart.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SimpleDepartmentApiLocalServiceAutoConfigure.class})
public class SimpleDepartmentApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={SimpleDepartmentApi.class})
    public SimpleDepartmentApi simpleDepartmentApiFeignWrapper(FeignSimpleDepartmentApi api) {
        return new SimpleDepartmentApiFeignWrapper(api);
    }

    private static class SimpleDepartmentApiFeignWrapper
    implements SimpleDepartmentApi {
        private final FeignSimpleDepartmentApi api;

        @Override
        public SimpleDepartmentDTO findOne(Long departmentId) {
            return Optional.ofNullable((SimpleDepartmentDTO)this.api.findOne(departmentId).getData()).orElseThrow(DepartmentInvalidException::new);
        }

        @Override
        public ListObject<SimpleDepartmentDTO> findList(DepartmentSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<SimpleDepartmentDTO> findAll(DepartmentSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public SimpleDepartmentApiFeignWrapper(FeignSimpleDepartmentApi api) {
            this.api = api;
        }
    }
}

