/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.service.handler.OperationLogHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class OperationLogApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={OperationLogHandler.class})
    public OperationLogApi operationLogApiLocalServiceWrapper(OperationLogHandler service) {
        return new OperationLogApiLocalServiceWrapper(service);
    }

    private static class OperationLogApiLocalServiceWrapper
    implements OperationLogApi {
        private final OperationLogHandler handler;

        @Override
        public void add(String operationContent, Long userId, Object ... operationParams) {
            this.handler.add(operationContent, userId, operationParams);
        }

        public OperationLogApiLocalServiceWrapper(OperationLogHandler handler) {
            this.handler = handler;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.user.service.handler.OperationLogHandler") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

