/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.api.autoconfig.OperationLogApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignOperationLogApi;
import net.guerlab.smart.user.core.domain.OperationLogDTO;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OperationLogApiLocalServiceAutoConfigure.class})
public class OperationLogApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={OperationLogApi.class})
    public OperationLogApi operationLogApiFeignWrapper(FeignOperationLogApi api, ApplicationContext applicationContext, ObjectMapper objectMapper) {
        return new OperationLogApiFeignWrapper(api, applicationContext, objectMapper);
    }

    private static class OperationLogApiFeignWrapper
    implements OperationLogApi {
        private final FeignOperationLogApi api;
        private final ApplicationContext applicationContext;
        private final ObjectMapper objectMapper;

        @Override
        public void add(String operationContent, Long userId, Object ... operationParams) {
            OperationLogDTO operationLog = new OperationLogDTO();
            operationLog.setApplicationName(this.applicationContext != null ? this.applicationContext.getEnvironment().getProperty("spring.application.name") : null);
            operationLog.setOperationContent(operationContent);
            try {
                operationLog.setOperationParams(this.objectMapper.writeValueAsString((Object)operationParams));
            }
            catch (Exception exception) {
                // empty catch block
            }
            operationLog.setUserId(userId);
            this.api.add(operationLog);
        }

        public OperationLogApiFeignWrapper(FeignOperationLogApi api, ApplicationContext applicationContext, ObjectMapper objectMapper) {
            this.api = api;
            this.applicationContext = applicationContext;
            this.objectMapper = objectMapper;
        }
    }
}

