/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.OauthApi;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.exception.OauthInvalidException;
import net.guerlab.smart.user.core.searchparams.OauthSearchParams;
import net.guerlab.smart.user.service.entity.Oauth;
import net.guerlab.smart.user.service.service.OauthService;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class OauthApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={OauthService.class})
    public OauthApi oauthApiLocalServiceWrapper(OauthService service) {
        return new OauthApiLocalServiceWrapper(service);
    }

    private static class OauthApiLocalServiceWrapper
    implements OauthApi {
        private final OauthService service;

        @Override
        public OauthDTO findOne(String type, Long userId) {
            return (OauthDTO)((Oauth)this.service.getOneOptional(type, userId).orElseThrow(OauthInvalidException::new)).toDTO();
        }

        @Override
        public OauthDTO findOne(String type, String thirdPartyId) {
            return (OauthDTO)((Oauth)this.service.getOneOptional(type, thirdPartyId).orElseThrow(OauthInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<OauthDTO> findList(OauthSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage(searchParams));
        }

        @Override
        public List<OauthDTO> findAll(OauthSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll(searchParams));
        }

        public OauthApiLocalServiceWrapper(OauthService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.user.service.service.OauthService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

