/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.user.api.OauthApi;
import net.guerlab.smart.user.api.autoconfig.OauthApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignOauthApi;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.exception.OauthInvalidException;
import net.guerlab.smart.user.core.searchparams.OauthSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OauthApiLocalServiceAutoConfigure.class})
public class OauthApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={OauthApi.class})
    public OauthApi oauthApiFeignWrapper(FeignOauthApi api) {
        return new OauthApiFeignWrapper(api);
    }

    private static class OauthApiFeignWrapper
    implements OauthApi {
        private final FeignOauthApi api;

        @Override
        public OauthDTO findOne(String type, Long userId) {
            return Optional.ofNullable((OauthDTO)this.api.byUserId(type, userId).getData()).orElseThrow(OauthInvalidException::new);
        }

        @Override
        public OauthDTO findOne(String type, String thirdPartyId) {
            return Optional.ofNullable((OauthDTO)this.api.byThirdPartyId(type, thirdPartyId).getData()).orElseThrow(OauthInvalidException::new);
        }

        @Override
        public ListObject<OauthDTO> findList(OauthSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<OauthDTO> findAll(OauthSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public OauthApiFeignWrapper(FeignOauthApi api) {
            this.api = api;
        }
    }
}

