/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.DutyApi;
import net.guerlab.smart.user.core.domain.DutyDTO;
import net.guerlab.smart.user.core.exception.DutyInvalidException;
import net.guerlab.smart.user.core.searchparams.DutySearchParams;
import net.guerlab.smart.user.service.entity.Duty;
import net.guerlab.smart.user.service.service.DutyService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class DutyApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DutyService.class})
    public DutyApi dutyApiLocalServiceWrapper(DutyService service) {
        return new DutyApiLocalServiceWrapper(service);
    }

    private static class DutyApiLocalServiceWrapper
    implements DutyApi {
        private final DutyService service;

        @Override
        public DutyDTO findOne(Long dutyId) {
            return (DutyDTO)((Duty)this.service.selectByIdOptional((Object)dutyId).orElseThrow(DutyInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<DutyDTO> findList(DutySearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<DutyDTO> findAll(DutySearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public DutyApiLocalServiceWrapper(DutyService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.user.service.service.DutyService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

