/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.user.api.DutyApi;
import net.guerlab.smart.user.api.autoconfig.DutyApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignDutyApi;
import net.guerlab.smart.user.core.domain.DutyDTO;
import net.guerlab.smart.user.core.exception.DutyInvalidException;
import net.guerlab.smart.user.core.searchparams.DutySearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DutyApiLocalServiceAutoConfigure.class})
public class DutyApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DutyApi.class})
    public DutyApi dutyApiFeignWrapper(FeignDutyApi api) {
        return new DutyApiFeignWrapper(api);
    }

    private static class DutyApiFeignWrapper
    implements DutyApi {
        private final FeignDutyApi api;

        @Override
        public DutyDTO findOne(Long dutyId) {
            return Optional.ofNullable((DutyDTO)this.api.findOne(dutyId).getData()).orElseThrow(DutyInvalidException::new);
        }

        @Override
        public ListObject<DutyDTO> findList(DutySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<DutyDTO> findAll(DutySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public DutyApiFeignWrapper(FeignDutyApi api) {
            this.api = api;
        }
    }
}

