/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.smart.user.api.DingTalkClientApi;
import net.guerlab.smart.user.service.service.DingTalkClientManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class DingTalkClientApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DingTalkClientManagerService.class})
    public DingTalkClientApi dingTalkClientApiLocalServiceWrapper(DingTalkClientManagerService managerService) {
        return new DingTalkClientApiLocalServiceWrapper(managerService);
    }

    private static class DingTalkClientApiLocalServiceWrapper
    implements DingTalkClientApi {
        private final DingTalkClientManagerService managerService;

        @Override
        public String getAccessToken(String appKey) {
            return this.getClient(appKey).getAccessToken();
        }

        private DingTalkClient getClient(String appKey) {
            return this.managerService.getClient(appKey);
        }

        public DingTalkClientApiLocalServiceWrapper(DingTalkClientManagerService managerService) {
            this.managerService = managerService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.user.service.service.DingTalkClientManagerService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

