/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.user.api.DingTalkClientApi;
import net.guerlab.smart.user.api.autoconfig.DingTalkClientApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignDingTalkClientApi;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DingTalkClientApiLocalServiceAutoConfigure.class})
public class DingTalkClientApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DingTalkClientApi.class})
    public DingTalkClientApi dingTalkClientApiFeignWrapper(FeignDingTalkClientApi api) {
        return new DingTalkClientApiFeignWrapper(api);
    }

    private static class DingTalkClientApiFeignWrapper
    implements DingTalkClientApi {
        private final FeignDingTalkClientApi api;

        @Override
        public String getAccessToken(String appKey) {
            Result<String> result = this.api.getAccessToken(appKey);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public DingTalkClientApiFeignWrapper(FeignDingTalkClientApi api) {
            this.api = api;
        }
    }
}

