/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.user.api.DepartmentTypeApi;
import net.guerlab.smart.user.api.autoconfig.DepartmentTypeApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignDepartmentTypeApi;
import net.guerlab.smart.user.core.domain.DepartmentTypeDTO;
import net.guerlab.smart.user.core.exception.DepartmentTypeInvalidException;
import net.guerlab.smart.user.core.searchparams.DepartmentTypeSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DepartmentTypeApiLocalServiceAutoConfigure.class})
public class DepartmentTypeApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DepartmentTypeApi.class})
    public DepartmentTypeApi departmentTypeApiFeignWrapper(FeignDepartmentTypeApi api) {
        return new DepartmentTypeApiFeignWrapper(api);
    }

    private static class DepartmentTypeApiFeignWrapper
    implements DepartmentTypeApi {
        private final FeignDepartmentTypeApi api;

        @Override
        public DepartmentTypeDTO findOne(String departmentTypeKey) {
            return Optional.ofNullable((DepartmentTypeDTO)this.api.findOne(departmentTypeKey).getData()).orElseThrow(DepartmentTypeInvalidException::new);
        }

        @Override
        public ListObject<DepartmentTypeDTO> findList(DepartmentTypeSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<DepartmentTypeDTO> findAll(DepartmentTypeSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public DepartmentTypeApiFeignWrapper(FeignDepartmentTypeApi api) {
            this.api = api;
        }
    }
}

