/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collection;
import java.util.List;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.api.DepartmentApi;
import net.guerlab.smart.user.core.domain.DepartmentDTO;
import net.guerlab.smart.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.user.service.entity.Department;
import net.guerlab.smart.user.service.service.DepartmentService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class DepartmentApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DepartmentService.class})
    public DepartmentApi departmentApiLocalServiceWrapper(DepartmentService service) {
        return new DepartmentApiLocalServiceWrapper(service);
    }

    private static class DepartmentApiLocalServiceWrapper
    implements DepartmentApi {
        private final DepartmentService service;

        @Override
        public DepartmentDTO findOne(Long departmentId) {
            return (DepartmentDTO)((Department)this.service.selectByIdOptional((Object)departmentId).orElseThrow(DepartmentInvalidException::new)).toDTO();
        }

        @Override
        public ListObject<DepartmentDTO> findList(DepartmentSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<DepartmentDTO> findAll(DepartmentSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public DepartmentApiLocalServiceWrapper(DepartmentService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.user.service.service.DepartmentService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

