/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.user.api.DepartmentApi;
import net.guerlab.smart.user.api.autoconfig.DepartmentApiLocalServiceAutoConfigure;
import net.guerlab.smart.user.api.feign.FeignDepartmentApi;
import net.guerlab.smart.user.core.domain.DepartmentDTO;
import net.guerlab.smart.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DepartmentApiLocalServiceAutoConfigure.class})
public class DepartmentApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DepartmentApi.class})
    public DepartmentApi departmentApiFeignWrapper(FeignDepartmentApi api) {
        return new DepartmentApiFeignWrapper(api);
    }

    private static class DepartmentApiFeignWrapper
    implements DepartmentApi {
        private final FeignDepartmentApi api;

        @Override
        public DepartmentDTO findOne(Long departmentId) {
            return Optional.ofNullable((DepartmentDTO)this.api.findOne(departmentId).getData()).orElseThrow(DepartmentInvalidException::new);
        }

        @Override
        public ListObject<DepartmentDTO> findList(DepartmentSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<DepartmentDTO> findAll(DepartmentSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public DepartmentApiFeignWrapper(FeignDepartmentApi api) {
            this.api = api;
        }
    }
}

