package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.user.api.feign.FeignOperationLogApi;
import net.guerlab.smart.user.core.domain.OperationLogDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 操作记录服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignOperationLogApiFallbackFactory implements FallbackFactory<FeignOperationLogApi> {

    @Override
    public FeignOperationLogApi create(Throwable cause) {
        return new FeignOperationLogApiFallback(cause);
    }

    /**
     * 操作记录服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignOperationLogApiFallback implements FeignOperationLogApi {

        private final Throwable cause;

        @Override
        public Result<Void> add(OperationLogDTO dto) {
            log.error("add fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
