package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.user.api.feign.FeignOauthApi;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * oauth信息服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignOauthApiFallbackFactory implements FallbackFactory<FeignOauthApi> {

    @Override
    public FeignOauthApi create(Throwable cause) {
        return new FeignOauthApiFallback(cause);
    }

    /**
     * oauth信息服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignOauthApiFallback implements FeignOauthApi {

        private final Throwable cause;

        @Override
        public Result<OauthDTO> byUserId(String type, Long userId) {
            log.error("byUserId fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<OauthDTO> byThirdPartyId(String type, String thirdPartyId) {
            log.error("byThirdPartyId fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<OauthDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<OauthDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }
}
