package net.guerlab.smart.user.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.user.api.feign.FeignDingTalkClientApi;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 钉钉应用快速失败类构建工厂
 *
 * @author guer
 */
public class FeignDingTalkClientApiFallbackFactory implements FallbackFactory<FeignDingTalkClientApi> {

    @Override
    public FeignDingTalkClientApi create(Throwable cause) {
        return new FeignDingTalkClientApiFallback(cause);
    }

    /**
     * 钉钉应用快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignDingTalkClientApiFallback implements FeignDingTalkClientApi {

        private final Throwable cause;

        @Override
        public Result<String> getAccessToken(String appKey) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
