package net.guerlab.smart.user.api.feign;

import net.guerlab.smart.user.api.feign.factory.FeignOperationLogApiFallbackFactory;
import net.guerlab.smart.user.core.domain.OperationLogDTO;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 操作记录服务接口
 *
 * @author guer
 */
@FeignClient(name = "user-internal/inside/operationLog", fallbackFactory = FeignOperationLogApiFallbackFactory.class)
public interface FeignOperationLogApi {

    /**
     * 添加操作记录
     *
     * @param dto
     *         操作记录
     * @return 响应
     */
    @PostMapping("/add")
    Result<Void> add(@RequestBody OperationLogDTO dto);
}
