package net.guerlab.smart.user.api.feign;

import net.guerlab.smart.user.api.feign.factory.FeignOauthApiFallbackFactory;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * oauth信息服务接口
 *
 * @author guer
 */
@FeignClient(name = "user-internal/inside/oauth", fallbackFactory = FeignOauthApiFallbackFactory.class)
public interface FeignOauthApi {

    /**
     * 根据类型和用户id查询oauth信息
     *
     * @param type
     *         类型
     * @param userId
     *         用户id
     * @return oauth信息
     */
    @GetMapping("/{type}/byUserId/{userId}")
    Result<OauthDTO> byUserId(@PathVariable("type") String type, @PathVariable("userId") Long userId);

    /**
     * 根据类型和第三方ID查询oauth信息
     *
     * @param type
     *         类型
     * @param thirdPartyId
     *         第三方ID
     * @return oauth信息
     */
    @GetMapping("/{type}/byThirdPartyId/{thirdPartyId}")
    Result<OauthDTO> byThirdPartyId(@PathVariable("type") String type, @PathVariable("thirdPartyId") String thirdPartyId);

    /**
     * 根据搜索参数查询oauth信息列表
     *
     * @param searchParams
     *         搜索参数
     * @return oauth信息列表
     */
    @PostMapping
    Result<ListObject<OauthDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询oauth信息列表
     *
     * @param searchParams
     *         搜索参数
     * @return oauth信息列表
     */
    @PostMapping("/all")
    Result<List<OauthDTO>> findAll(@RequestBody Map<String, Object> searchParams);

}
