package net.guerlab.smart.user.api.feign;

import net.guerlab.smart.user.api.feign.factory.FeignDingTalkClientApiFallbackFactory;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 钉钉应用接口
 *
 * @author guer
 */
@FeignClient(name = "user-internal/inside/dingTalkClient", fallbackFactory = FeignDingTalkClientApiFallbackFactory.class)
public interface FeignDingTalkClientApi {

    /**
     * 根据钉钉应用id查询钉钉应用accessToken
     *
     * @param appKey
     *         appKey
     * @return accessToken
     */
    @GetMapping("/{appKey}/accessToken")
    Result<String> getAccessToken(@PathVariable("appKey") String appKey);
}
