package net.guerlab.smart.user.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.user.api.OauthApi;
import net.guerlab.smart.user.api.feign.FeignOauthApi;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.exception.OauthInvalidException;
import net.guerlab.smart.user.core.searchparams.OauthSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(OauthApiLocalServiceAutoConfigure.class)
public class OauthApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(OauthApi.class)
    public OauthApi oauthApiFeignWrapper(FeignOauthApi api) {
        return new OauthApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class OauthApiFeignWrapper implements OauthApi {

        private final FeignOauthApi api;

        @Override
        public OauthDTO findOne(String type, Long userId) {
            return Optional.ofNullable(api.byUserId(type, userId).getData()).orElseThrow(OauthInvalidException::new);
        }

        @Override
        public OauthDTO findOne(String type, String thirdPartyId) {
            return Optional.ofNullable(api.byThirdPartyId(type, thirdPartyId).getData())
                    .orElseThrow(OauthInvalidException::new);
        }

        @Override
        public ListObject<OauthDTO> findList(OauthSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<OauthDTO> findAll(OauthSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
