package net.guerlab.smart.user.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.smart.user.api.DingTalkClientApi;
import net.guerlab.smart.user.service.service.DingTalkClientManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

/**
 * @author guer
 */
@Configuration
@Conditional(DingTalkClientApiLocalServiceAutoConfigure.WrapperCondition.class)
public class DingTalkClientApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(DingTalkClientManagerService.class)
    public DingTalkClientApi dingTalkClientApiLocalServiceWrapper(DingTalkClientManagerService managerService) {
        return new DingTalkClientApiLocalServiceWrapper(managerService);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.user.service.service.DingTalkClientManagerService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class DingTalkClientApiLocalServiceWrapper implements DingTalkClientApi {

        private final DingTalkClientManagerService managerService;

        @Override
        public String getAccessToken(String appKey) {
            return getClient(appKey).getAccessToken();
        }

        private DingTalkClient getClient(String appKey) {
            return managerService.getClient(appKey);
        }
    }

}
