package net.guerlab.smart.user.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.user.api.DingTalkClientApi;
import net.guerlab.smart.user.api.feign.FeignDingTalkClientApi;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(DingTalkClientApiLocalServiceAutoConfigure.class)
public class DingTalkClientApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(DingTalkClientApi.class)
    public DingTalkClientApi dingTalkClientApiFeignWrapper(FeignDingTalkClientApi api) {
        return new DingTalkClientApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class DingTalkClientApiFeignWrapper implements DingTalkClientApi {

        private final FeignDingTalkClientApi api;

        @Override
        public String getAccessToken(String appKey) {
            Result<String> result = api.getAccessToken(appKey);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }
    }

}
