package net.guerlab.smart.user.api;

import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.searchparams.OauthSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * oauth信息服务接口
 *
 * @author guer
 */
public interface OauthApi {

    /**
     * 根据类型和用户id查询oauth信息
     *
     * @param type
     *         类型
     * @param userId
     *         用户id
     * @return oauth信息
     */
    OauthDTO findOne(String type, Long userId);

    /**
     * 根据类型和第三方ID查询oauth信息
     *
     * @param type
     *         类型
     * @param thirdPartyId
     *         第三方ID
     * @return oauth信息
     */
    OauthDTO findOne(String type, String thirdPartyId);

    /**
     * 根据搜索参数查询oauth信息列表
     *
     * @param searchParams
     *         搜索参数
     * @return oauth信息列表
     */
    ListObject<OauthDTO> findList(OauthSearchParams searchParams);

    /**
     * 根据搜索参数查询oauth信息列表
     *
     * @param searchParams
     *         搜索参数
     * @return oauth信息列表
     */
    List<OauthDTO> findAll(OauthSearchParams searchParams);
}
