/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import net.guerlab.smart.platform.commons.annotation.HasPermission;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.service.crons.DistrictSyncCron;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.web.controller.AbstractRegionController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5730\u533a")
@RestController(value="/user/region")
@RequestMapping(value={"/user/region"})
public class RegionController
extends AbstractRegionController {
    private DistrictSyncCron districtSyncCron;
    private OperationLogApi operationLogApi;

    @HasPermission(value="hasKey(REGION_MANAGER)")
    @Operation(description="\u6dfb\u52a0", security={@SecurityRequirement(name="Authorization")})
    @PostMapping
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO save(@Parameter(name="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = new Region();
        this.copyProperties(dto, entity);
        entity.setRegionId(dto.getRegionId());
        this.service.insert((Object)entity);
        this.operationLogApi.add("\u6dfb\u52a0\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)entity.convert();
    }

    @HasPermission(value="hasKey(REGION_MANAGER)")
    @Operation(description="\u7f16\u8f91", security={@SecurityRequirement(name="Authorization")})
    @PutMapping(value={"/{regionId}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO update(@Parameter(name="\u5730\u533aID", required=true) @PathVariable Long regionId, @Parameter(name="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = this.findOne0(regionId);
        this.copyProperties(dto, entity);
        this.service.updateById((Object)entity);
        this.operationLogApi.add("\u7f16\u8f91\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)((Region)this.service.selectById((Serializable)regionId)).convert();
    }

    @HasPermission(value="hasKey(REGION_MANAGER)")
    @Operation(description="\u5220\u9664", security={@SecurityRequirement(name="Authorization")})
    @DeleteMapping(value={"/{regionId}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void delete(@Parameter(name="\u5730\u533aID", required=true) @PathVariable Long regionId, @Parameter(name="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        this.findOne0(regionId);
        this.service.deleteById((Serializable)regionId, force);
        this.operationLogApi.add("\u5220\u9664\u5730\u533a", UserContextHandler.getUserId(), new Object[]{regionId});
    }

    @HasPermission(value="hasKey(REGION_MANAGER)")
    @Operation(description="\u5220\u9664\u7f13\u5b58", security={@SecurityRequirement(name="Authorization")})
    @DeleteMapping(value={"/cache"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void deleteCache() {
        this.operationLogApi.add("\u5220\u9664\u5730\u533a\u7f13\u5b58", UserContextHandler.getUserId(), new Object[0]);
    }

    @HasPermission(value="hasKey(REGION_MANAGER)")
    @Operation(description="\u540c\u6b65\u6570\u636e", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/sync"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void sync() {
        this.districtSyncCron.sync();
        this.operationLogApi.add("\u540c\u6b65\u5730\u533a\u6570\u636e", UserContextHandler.getUserId(), new Object[0]);
    }

    private void copyProperties(RegionDTO dto, Region entity) {
        entity.setRegionName(dto.getRegionName());
        entity.setParentId(dto.getParentId());
        entity.setOrderNum(dto.getOrderNum());
    }

    @Autowired
    public void setDistrictSyncCron(DistrictSyncCron districtSyncCron) {
        this.districtSyncCron = districtSyncCron;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

