/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.web.controller.commons;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.service.lbs.service.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * lbs搜索服务
 *
 * @author guer
 */
@Tag(name = "lbs搜索服务")
@RestController("/commons/search")
@RequestMapping("/commons/search")
public class SearchController {

    private SearchService searchService;

    @Operation(description = "地址解析响应结果")
    @GetMapping("/geocoder")
    public GeocoderResult geocoder(@Parameter(name = "结构化地址信息", required = true) @RequestParam String address) {
        return searchService.geocoder(address);
    }

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }
}
