/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.web.controller.commons;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.region.service.lbs.entity.IpQueryResult;
import net.guerlab.smart.region.service.lbs.service.IpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * IP
 *
 * @author guer
 */
@Tag(name = "IP")
@RestController("/commons/ip")
@RequestMapping("/commons/ip")
public class IpController {

    private IpService ipService;

    @Operation(description = "查询当前请求ip地址的地理位置信息")
    @GetMapping
    public IpQueryResult query(HttpServletRequest request) {
        return ipService.query(IpUtils.getIp(request));
    }

    @Operation(description = "查询指定ip地址的地理位置信息")
    @GetMapping("/{ip}")
    public IpQueryResult query(@PathVariable String ip) {
        return ipService.query(ip);
    }

    @Autowired
    public void setIpService(IpService ipService) {
        this.ipService = ipService;
    }
}
