/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.web.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionIdInvalidException;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public class AbstractRegionController {
    protected RegionService service;

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/{regionId}"})
    public RegionDTO findOne(@ApiParam(value="\u5730\u533aID", required=true) @PathVariable Long regionId) {
        return (RegionDTO)this.findOne0(regionId).toDTO();
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0b\u7ea7\u5217\u8868")
    @GetMapping(value={"/{regionId}/children"})
    @Cacheable(value={"region"}, key="#regionId")
    public Collection<RegionDTO> findChildren(@ApiParam(value="regionId", required=true) @PathVariable Long regionId) {
        if (!NumberHelper.greaterZero((Number)regionId)) {
            regionId = Constants.DEFAULT_PARENT_ID;
        }
        RegionSearchParams searchParams = new RegionSearchParams();
        searchParams.setParentId(regionId);
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @ApiOperation(value="\u67e5\u8be2\u6df1\u5ea6\u5217\u8868")
    @GetMapping(value={"/{regionId}/depth"})
    public Collection<RegionDTO> findDepthList(@ApiParam(value="regionId", required=true) @PathVariable Long regionId) {
        return this.service.findDepthList(regionId).stream().map(DefaultConvertDTO::toDTO).collect(Collectors.toList());
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u5f62\u7ed3\u6784")
    @GetMapping(value={"/tree"})
    @Cacheable(value={"region"}, key="'tree'")
    public Collection<RegionDTO> getTree() {
        return TreeUtils.tree((Collection)CollectionUtil.toList((Collection)this.service.selectAll(), DefaultConvertDTO::toDTO));
    }

    protected Region findOne0(Long regionId) {
        if (!NumberHelper.greaterZero((Number)regionId)) {
            throw new RegionIdInvalidException();
        }
        return (Region)this.service.selectByIdOptional((Object)regionId).orElseThrow(RegionInvalidException::new);
    }

    @Autowired
    public void setService(RegionService service) {
        this.service = service;
    }
}

