package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.region.core.entity.GeocoderResult;
import net.guerlab.smart.region.service.lbs.service.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * lbs搜索服务
 *
 * @author guer
 */
@Api(tags = "lbs搜索服务")
@RestController("/commons/search")
@RequestMapping("/commons/search")
public class SearchController {

    private SearchService searchService;

    @ApiOperation("地址解析响应结果")
    @GetMapping("/geocoder")
    public GeocoderResult geocoder(@ApiParam(value = "结构化地址信息", required = true) @RequestParam String address) {
        return searchService.geocoder(address);
    }

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }
}
