package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.region.service.lbs.entity.IpQueryResult;
import net.guerlab.smart.region.service.lbs.service.IpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * IP
 *
 * @author guer
 */
@Api(tags = "IP")
@RestController("/commons/ip")
@RequestMapping("/commons/ip")
public class IpController {

    private IpService ipService;

    @ApiOperation("查询当前请求ip地址的地理位置信息")
    @GetMapping
    public IpQueryResult query(HttpServletRequest request) {
        return ipService.query(IpUtils.getIp(request));
    }

    @ApiOperation("查询指定ip地址的地理位置信息")
    @GetMapping("/{ip}")
    public IpQueryResult query(@PathVariable String ip) {
        return ipService.query(ip);
    }

    @Autowired
    public void setIpService(IpService ipService) {
        this.ipService = ipService;
    }
}
