/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.service.crons.DistrictSyncCron;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.web.controller.AbstractRegionController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5730\u533a"})
@RestController(value="/user/region")
@RequestMapping(value={"/user/region"})
public class RegionController
extends AbstractRegionController {
    private DistrictSyncCron districtSyncCron;
    private OperationLogApi operationLogApi;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO save(@ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = new Region();
        this.copyProperties(dto, entity);
        entity.setRegionId(dto.getRegionId());
        this.service.insert((Object)entity);
        this.operationLogApi.add("\u6dfb\u52a0\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)entity.toDTO();
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{regionId}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO update(@ApiParam(value="\u5730\u533aID", required=true) @PathVariable Long regionId, @ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = this.findOne0(regionId);
        this.copyProperties(dto, entity);
        this.service.updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u7f16\u8f91\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)((Region)this.service.selectById((Object)regionId)).toDTO();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{regionId}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void delete(@ApiParam(value="\u5730\u533aID", required=true) @PathVariable Long regionId, @ApiParam(value="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        this.findOne0(regionId);
        this.service.deleteById((Object)regionId, force);
        this.operationLogApi.add("\u5220\u9664\u5730\u533a", UserContextHandler.getUserId(), new Object[]{regionId});
    }

    @ApiOperation(value="\u5220\u9664\u7f13\u5b58")
    @DeleteMapping(value={"/cache"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void deleteCache() {
        this.operationLogApi.add("\u5220\u9664\u5730\u533a\u7f13\u5b58", UserContextHandler.getUserId(), new Object[0]);
    }

    @ApiOperation(value="\u540c\u6b65\u6570\u636e")
    @PostMapping(value={"/sync"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void sync() {
        this.districtSyncCron.sync();
        this.operationLogApi.add("\u540c\u6b65\u5730\u533a\u6570\u636e", UserContextHandler.getUserId(), new Object[0]);
    }

    private void copyProperties(RegionDTO dto, Region entity) {
        entity.setRegionName(dto.getRegionName());
        entity.setParentId(dto.getParentId());
        entity.setOrderNum(dto.getOrderNum());
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

    @Autowired
    public void setDistrictSyncCron(DistrictSyncCron districtSyncCron) {
        this.districtSyncCron = districtSyncCron;
    }
}

