package net.guerlab.smart.region.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.core.exception.RegionInvalidException;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.Collection;
import java.util.stream.Collectors;

/**
 * 树形地区
 *
 * @author guer
 */
@Api(tags = "树形地区")
public class AbstractRegionController
        extends BaseFindController<RegionDTO, Region, RegionService, RegionSearchParams, Long> {

    @Cacheable(value = "region", key = "'tree'")
    @ApiOperation("获取树形结构")
    @GetMapping("/tree")
    public Collection<RegionDTO> getTree() {
        return TreeUtils.tree(CollectionUtil.toList(getService().selectAll(), Region::toDTO));
    }

    @ApiOperation("获取深度列表")
    @GetMapping("/{id}/depth")
    public Collection<RegionDTO> findDepthList(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return getService().findDepthList(id).stream().map(Region::toDTO).collect(Collectors.toList());
    }

    @Override
    protected ApplicationException nullPointException() {
        return new RegionInvalidException();
    }
}
