/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.service.RegionService;
import net.guerlab.smart.region.web.controller.AbstractRegionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5730\u533a"})
@RestController(value="/user/region")
@RequestMapping(value={"/user/region"})
public class RegionController
extends AbstractRegionController {
    private OperationLogApi operationLogApi;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO save(@ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = new Region();
        this.copyProperties(dto, entity);
        entity.setRegionId(dto.getRegionId());
        ((RegionService)this.getService()).insert((Object)entity);
        this.operationLogApi.add("\u6dfb\u52a0\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)entity.toDTO();
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{id}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public RegionDTO update(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody RegionDTO dto) {
        Region entity = (Region)this.findOne0((Object)id);
        this.copyProperties(dto, entity);
        ((RegionService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u7f16\u8f91\u5730\u533a", UserContextHandler.getUserId(), new Object[]{entity});
        return (RegionDTO)((Region)((RegionService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    @CacheEvict(value={"region"}, allEntries=true)
    public void delete(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        this.findOne0((Object)id);
        ((RegionService)this.getService()).deleteById((Object)id, force);
        this.operationLogApi.add("\u5220\u9664\u5730\u533a", UserContextHandler.getUserId(), new Object[]{id});
    }

    private void copyProperties(RegionDTO dto, Region entity) {
        entity.setRegionName(dto.getRegionName());
        entity.setParentId(dto.getParentId());
        entity.setOrderNum(dto.getOrderNum());
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

