package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.region.core.domain.RegionDTO;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.web.controller.AbstractRegionController;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.*;

/**
 * 地区
 *
 * @author guer
 */
@Api(tags = "地区")
@RestController("/user/region")
@RequestMapping("/user/region")
public class RegionController extends AbstractRegionController {

    @ApiOperation("添加")
    @PostMapping
    @CacheEvict(value = "region", allEntries = true)
    public RegionDTO save(@ApiParam(value = "对象数据", required = true) @RequestBody RegionDTO dto) {
        Region entity = new Region();
        copyProperties(dto, entity);
        entity.setRegionId(dto.getRegionId());
        getService().insert(entity);
        return entity.toDTO();
    }

    @ApiOperation("编辑")
    @PutMapping("/{id}")
    @CacheEvict(value = "region", allEntries = true)
    public RegionDTO update(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "对象数据", required = true) @RequestBody RegionDTO dto) {
        Region entity = findOne0(id);
        copyProperties(dto, entity);
        getService().updateSelectiveById(entity);
        return getService().selectById(id).toDTO();
    }

    @ApiOperation("删除")
    @DeleteMapping("/{id}")
    @CacheEvict(value = "region", allEntries = true)
    public void delete(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "强制删除标志") @RequestParam(required = false) Boolean force) {
        findOne0(id);
        getService().deleteById(id, force);
    }

    private void copyProperties(RegionDTO dto, Region entity) {
        entity.setRegionName(dto.getRegionName());
        entity.setParentId(dto.getParentId());
        entity.setOrderNum(dto.getOrderNum());
    }
}
