package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.core.exception.ProvinceInvalidException;
import net.guerlab.smart.region.core.searchparams.ProvinceSearchParams;
import net.guerlab.smart.region.service.entity.Province;
import net.guerlab.smart.region.service.service.ProvinceService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 省
 *
 * @author guer
 */
@Api(tags = "省")
@RestController("/user/province")
@RequestMapping("/user/province")
public class ProvinceController
        extends BaseController<ProvinceDTO, Province, ProvinceService, ProvinceSearchParams, Long> {

    @Override
    public void copyProperties(ProvinceDTO dto, Province entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setProvinceId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new ProvinceInvalidException();
    }
}
