package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.entity.City;
import net.guerlab.smart.region.service.service.CityService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 市
 *
 * @author guer
 */
@Api(tags = "市")
@RestController("/user/city")
@RequestMapping("/user/city")
public class CityController extends BaseController<CityDTO, City, CityService, CitySearchParams, Long> {

    @Override
    public void copyProperties(CityDTO dto, City entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setCityId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new CityInvalidException();
    }
}
