package net.guerlab.smart.region.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.smart.region.service.entity.Area;
import net.guerlab.smart.region.service.service.AreaService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 区
 *
 * @author guer
 */
@Api(tags = "区")
@RestController("/user/area")
@RequestMapping("/user/area")
public class AreaController extends BaseController<AreaDTO, Area, AreaService, AreaSearchParams, Long> {

    @Override
    public void copyProperties(AreaDTO dto, Area entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setAreaId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new AreaInvalidException();
    }
}
