package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.service.service.AreaService;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.smart.region.service.service.ProvinceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 区
 *
 * @author guer
 */
@Api(tags = "区")
@RestController("/commons/tree")
@RequestMapping("/commons/tree")
public class TreeController {

    private ProvinceService provinceService;

    private CityService cityService;

    private AreaService areaService;

    @GetMapping
    public Collection<ProvinceDTO> getTree() {
        List<ProvinceDTO> provinceList = BeanConvertUtils.toList(provinceService.selectAll());
        List<CityDTO> cityList = BeanConvertUtils.toList(cityService.selectAll());
        List<AreaDTO> areaList = BeanConvertUtils.toList(areaService.selectAll());
        Map<Long, List<CityDTO>> cityMap = CollectionUtil.group(cityList, CityDTO::getProvinceId);
        Map<Long, List<AreaDTO>> areaMap = CollectionUtil.group(areaList, AreaDTO::getCityId);
        provinceList.forEach(province -> province
                .setChildren(cityMap.getOrDefault(province.getProvinceId(), Collections.emptyList())));
        cityList.forEach(city -> city.setChildren(areaMap.getOrDefault(city.getCityId(), Collections.emptyList())));

        return provinceList;
    }

    @Autowired
    public void setProvinceService(ProvinceService provinceService) {
        this.provinceService = provinceService;
    }

    @Autowired
    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    @Autowired
    public void setAreaService(AreaService areaService) {
        this.areaService = areaService;
    }
}
