package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.exception.CityInvalidException;
import net.guerlab.smart.region.core.searchparams.CitySearchParams;
import net.guerlab.smart.region.service.entity.City;
import net.guerlab.smart.region.service.service.CityService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 市
 *
 * @author guer
 */
@Api(tags = "市")
@RestController("/commons/city")
@RequestMapping("/commons/city")
public class CityController extends BaseFindController<CityDTO, City, CityService, CitySearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new CityInvalidException();
    }
}
