package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.exception.AreaInvalidException;
import net.guerlab.smart.region.core.searchparams.AreaSearchParams;
import net.guerlab.smart.region.service.entity.Area;
import net.guerlab.smart.region.service.service.AreaService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 区
 *
 * @author guer
 */
@Api(tags = "区")
@RestController("/commons/area")
@RequestMapping("/commons/area")
public class AreaController extends BaseFindController<AreaDTO, Area, AreaService, AreaSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new AreaInvalidException();
    }
}
