/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.web.controller.commons;

import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.region.core.domain.AreaDTO;
import net.guerlab.smart.region.core.domain.CityDTO;
import net.guerlab.smart.region.core.domain.ProvinceDTO;
import net.guerlab.smart.region.service.service.AreaService;
import net.guerlab.smart.region.service.service.CityService;
import net.guerlab.smart.region.service.service.ProvinceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u533a"})
@RestController(value="/commons/tree")
@RequestMapping(value={"/commons/tree"})
public class TreeController {
    private ProvinceService provinceService;
    private CityService cityService;
    private AreaService areaService;

    @GetMapping
    public Collection<ProvinceDTO> getTree() {
        List provinceList = BeanConvertUtils.toList((Collection)this.provinceService.selectAll());
        List cityList = BeanConvertUtils.toList((Collection)this.cityService.selectAll());
        List areaList = BeanConvertUtils.toList((Collection)this.areaService.selectAll());
        Map cityMap = CollectionUtil.group((Collection)cityList, CityDTO::getProvinceId);
        Map areaMap = CollectionUtil.group((Collection)areaList, AreaDTO::getCityId);
        provinceList.forEach(province -> province.setChildren((Collection)cityMap.getOrDefault(province.getProvinceId(), Collections.emptyList())));
        cityList.forEach(city -> city.setChildren((Collection)areaMap.getOrDefault(city.getCityId(), Collections.emptyList())));
        return provinceList;
    }

    @Autowired
    public void setProvinceService(ProvinceService provinceService) {
        this.provinceService = provinceService;
    }

    @Autowired
    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    @Autowired
    public void setAreaService(AreaService areaService) {
        this.areaService = areaService;
    }
}

