/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.region.service.lbs.entity.IpQueryResult;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.IpService;
import net.guerlab.smart.region.service.lbs.service.impl.AbstractServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IpServiceImpl
extends AbstractServiceImpl
implements IpService {
    private static final Logger log = LoggerFactory.getLogger(IpServiceImpl.class);

    @Override
    public IpQueryResult query(String ip) {
        int retryNumber = this.getRetryNumber();
        int i = 0;
        while (true) {
            ++i;
            try {
                String key = this.getKey();
                String content = this.getResult("https://apis.map.qq.com/ws/location/v1/ip?ip=" + ip + "&key=" + key);
                LbsResponse result = (LbsResponse)this.objectMapper.readValue(content, (TypeReference)new TypeReference<LbsResponse<IpQueryResult>>(){});
                IpQueryResult data = (IpQueryResult)this.resultCheck(key, result);
                this.dataCheck(data);
                return data;
            }
            catch (Exception e) {
                if (i < retryNumber) continue;
                throw e instanceof ApplicationException ? (ApplicationException)e : new ApplicationException((Throwable)e);
            }
            break;
        }
    }
}

