/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.region.service.lbs.entity.District;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.DistrictService;
import net.guerlab.smart.region.service.lbs.service.impl.AbstractServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistrictServiceImpl
extends AbstractServiceImpl
implements DistrictService {
    private static final Logger log = LoggerFactory.getLogger(DistrictServiceImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<District> getChildren(Long regionId) {
        int retryNumber = this.getRetryNumber();
        int i = 0;
        while (true) {
            ++i;
            try {
                String key = this.getKey();
                Object url = "http://apis.map.qq.com/ws/district/v1/getchildren";
                url = NumberHelper.greaterZero((Number)regionId) ? (String)url + "?id=" + regionId + "&key=" + key : (String)url + "?&key=" + key;
                log.debug("current url {}", url);
                LbsResponse result = (LbsResponse)this.objectMapper.readValue(this.getResult((String)url), (TypeReference)new TypeReference<LbsResponse<List<List<District>>>>(){});
                List data = (List)this.resultCheck(key, result);
                this.dataCheck(data);
                if (data.isEmpty()) continue;
                return (Collection)data.get(0);
            }
            catch (Exception e) {
                if (i >= retryNumber) throw e instanceof ApplicationException ? (ApplicationException)e : new ApplicationException((Throwable)e);
                continue;
            }
            break;
        }
    }
}

