/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Objects;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.region.core.exception.LbsKeyInvalidException;
import net.guerlab.smart.region.core.exception.LbsQueryInvalidException;
import net.guerlab.smart.region.service.lbs.KeyLoadBalancerAgent;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.properties.LbsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractServiceImpl.class);
    protected static final Integer[] KEY_ERROR_CODES = new Integer[]{190, 311};
    protected final HttpClient httpClient = HttpClient.newHttpClient();
    protected KeyLoadBalancerAgent keyLoadBalancer;
    protected LbsProperties lbsProperties;
    protected ObjectMapper objectMapper;

    protected int getRetryNumber() {
        int retryNumber = this.lbsProperties.getRetryNumber();
        if (retryNumber <= 0) {
            retryNumber = 3;
        }
        return retryNumber;
    }

    protected void dataCheck(Object data) {
        if (data == null) {
            throw new LbsQueryInvalidException();
        }
    }

    protected final String getResult(String url) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).GET().build();
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected final String getKey() {
        String key = this.keyLoadBalancer.choose();
        if (key == null) {
            throw new LbsKeyInvalidException();
        }
        return key;
    }

    protected <T> T resultCheck(String key, LbsResponse<T> result) {
        try {
            if (result.getStatus() != 0) {
                if (Arrays.stream(KEY_ERROR_CODES).anyMatch(errorCode -> Objects.equals(errorCode, result.getStatus()))) {
                    this.keyLoadBalancer.markDown(key);
                }
                throw new ApplicationException(result.getMessage());
            }
            return result.getResult();
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw e;
            }
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Autowired
    public void setKeyLoadBalancer(KeyLoadBalancerAgent keyLoadBalancer) {
        this.keyLoadBalancer = keyLoadBalancer;
    }

    @Autowired
    public void setLbsProperties(LbsProperties lbsProperties) {
        this.lbsProperties = lbsProperties;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

