/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.lbs;

import net.guerlab.loadbalancer.ILoadBalancer;
import net.guerlab.loadbalancer.RoundRobinLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;
import net.guerlab.smart.region.service.lbs.properties.LbsProperties;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;

public class KeyLoadBalancerAgent {
    private final ILoadBalancer<String, Object> keyLoadBalancer = new RoundRobinLoadBalancer();

    public void refreshLbsProperties(LbsProperties lbsProperties) {
        this.keyLoadBalancer.clear();
        this.keyLoadBalancer.addTargets(lbsProperties.getKeys(), Boolean.valueOf(true));
    }

    public String choose() {
        return (String)this.keyLoadBalancer.choose();
    }

    public void markDown(String target) {
        if (target == null) {
            return;
        }
        this.keyLoadBalancer.markDown(TargetWrapper.of((Object)target));
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    public void lbsPropertiesRefreshedHandler() {
        this.refreshLbsProperties((LbsProperties)SpringApplicationContextUtil.getContext().getBean(LbsProperties.class));
    }

    @Autowired
    public void setProperties(LbsProperties properties) {
        this.refreshLbsProperties(properties);
    }
}

