/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.region.service.crons;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.guerlab.smart.region.service.entity.Region;
import net.guerlab.smart.region.service.lbs.entity.District;
import net.guerlab.smart.region.service.lbs.service.DistrictService;
import net.guerlab.smart.region.service.service.RegionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DistrictSyncCron {
    private static final int BATCH_NUMBER = 1000;
    private final ReentrantLock lock = new ReentrantLock();
    private DistrictService districtService;
    private RegionService regionService;

    @Scheduled(cron="0 0 1 * * ? ")
    public void sync() {
        if (this.lock.tryLock()) {
            List<Region> all = this.getData(0L);
            for (int i = 0; i < all.size(); i += 1000) {
                List<Region> subList = all.subList(i, Math.min(i + 1000, all.size()));
                this.regionService.replaceBatchInsert(subList);
            }
            this.lock.unlock();
        }
    }

    private List<Region> getData(Long parentId) {
        List<Region> list = this.getRegions(parentId);
        ArrayList<Region> result = new ArrayList<Region>(list);
        for (Region region : list) {
            Long regionId = region.getRegionId();
            if (!regionId.toString().endsWith("00")) continue;
            result.addAll(this.getData(regionId));
        }
        return result;
    }

    private List<Region> getRegions(Long parentId) {
        return this.districtService.getChildren(parentId).stream().map(district -> this.toRegion((District)district, parentId)).collect(Collectors.toList());
    }

    private Region toRegion(District district, Long parentId) {
        String name = StringUtils.trimToNull((String)district.getName());
        String fullName = StringUtils.trimToNull((String)district.getFullName());
        Region region = new Region();
        region.setRegionId(district.getId());
        region.setRegionName(name != null ? name : fullName);
        region.setFullName(fullName);
        region.setParentId(parentId);
        region.setLatitude(district.getLocation().getLat());
        region.setLongitude(district.getLocation().getLng());
        region.setOrderNum(0);
        region.setVersion(0L);
        return region;
    }

    @Autowired
    public void setDistrictService(DistrictService districtService) {
        this.districtService = districtService;
    }

    @Autowired
    public void setRegionService(RegionService regionService) {
        this.regionService = regionService;
    }
}

