/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.service;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseBatchSaveService;
import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.region.core.searchparams.RegionSearchParams;
import net.guerlab.smart.region.service.entity.Region;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;

/**
 * 地区服务
 *
 * @author guer
 */
public interface RegionService extends BaseService<Region, Long, RegionSearchParams>, BaseBatchSaveService<Region, RegionSearchParams> {

    /**
     * 地区名称最大长度
     */
    int REGION_NAME_MAX_LENGTH = 100;

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<Region> getEntityClass() {
        return Region.class;
    }

    /**
     * 获取深度列表
     *
     * @param regionId
     *         地区ID
     * @return 深度列表
     */
    default Collection<Region> findDepthList(Long regionId) {
        Region region = selectById(regionId);

        if (region == null) {
            return Collections.emptyList();
        }

        Deque<Region> deque = new ArrayDeque<>();
        deque.addFirst(region);

        Long currentId = region.getParentId();
        Region currentRegion;
        while (true) {
            if (!NumberHelper.greaterZero(currentId)) {
                break;
            }

            currentRegion = selectById(currentId);

            if (currentRegion == null) {
                break;
            }
            deque.addFirst(currentRegion);

            currentId = currentRegion.getParentId();
        }

        return deque;
    }
}
