/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.region.service.lbs.entity.District;
import net.guerlab.smart.region.service.lbs.entity.LbsResponse;
import net.guerlab.smart.region.service.lbs.service.DistrictService;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * @author guer
 */
@Slf4j
@Service
public class DistrictServiceImpl extends AbstractServiceImpl implements DistrictService {

    @Override
    public Collection<District> getChildren(Long regionId) {
        int retryNumber = getRetryNumber();
        int i = 0;
        while (true) {
            i++;
            try {
                String key = getKey();

                String url = "http://apis.map.qq.com/ws/district/v1/getchildren";

                if (NumberHelper.greaterZero(regionId)) {
                    url += "?id=" + regionId + "&key=" + key;
                } else {
                    url += "?&key=" + key;
                }

                log.debug("current url {}", url);

                LbsResponse<List<List<District>>> result = objectMapper.readValue(getResult(url), new TypeReference<>() {});
                List<List<District>> data = resultCheck(key, result);
                dataCheck(data);
                if (!data.isEmpty()) {
                    return data.get(0);
                }
            } catch (Exception e) {
                if (i >= retryNumber) {
                    throw e instanceof ApplicationException ? (ApplicationException) e : new ApplicationException(e);
                }
            }
        }
    }
}
