/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.service;

import net.guerlab.smart.region.service.lbs.entity.District;

import java.util.Collection;

/**
 * 查询行政区划
 *
 * @author guer
 */
public interface DistrictService {

    /**
     * 查询下级行政区划
     *
     * @param regionId
     *         地区ID
     * @return 下级行政区划
     */
    Collection<District> getChildren(Long regionId);

}
