/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.region.service.lbs.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * lbs配置
 *
 * @author guer
 */
@Data
@ConfigurationProperties("lbs")
public class LbsProperties {

    /**
     * 默认重试次数
     */
    public static final int DEFAULT_RETRY_NUMBER = 3;

    /**
     * key列表
     */
    private List<String> keys = new ArrayList<>();

    /**
     * 重试次数
     */
    private int retryNumber = 3;
}
